#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "scripts.h"
#include "engine.h"
#ifndef WIN32
#include <dlfcn.h>
#include <time.h>
#endif
#ifdef WIN32
#define SCRIPTSAPI __declspec(dllexport)
#else
#define SCRIPTSAPI
#endif
typedef void (*srdf) (rdf);
typedef void (*ds) (ScriptClass *scr);
typedef ScriptClass *(*cs) (const char *);
typedef int (*gsc) ();
typedef char *(*gsn) (int);
typedef char *(*gspd) (int);
typedef bool (*ssc) (ScriptCommandsClass *);
#ifdef WIN32
HINSTANCE wwscripts;
#endif
cs CreateScript;
ds DestroyScript;
gsc GetScriptCount;
gsn GetScriptName;
gspd GetScriptParamDescription;
srdf SetRequestDestroyFunc;
unsigned int OldCount;
ScriptCommandsClass Commands;
ssc SetScriptCommands;
#ifdef WIN32
HMODULE bhs;
#define Address GetProcAddress
#else
#define Address dlsym
void *bhs;
#endif
extern "C"
{
#ifdef WIN32
	const unsigned char Code[19] = {0x6A,0x40,0xFF,0x74,0x24,0x0C,0xFF,0x74,0x24,0x0C,0xE8,0xC0,0xFF,0xFF,0xFF,0x83,0xC4,0x0C,0xC3};
BOOL SCRIPTSAPI __stdcall DllMain( HANDLE hModule, 
						DWORD	ul_reason_for_call, 
						LPVOID	lpReserved
					 )
{
	int LastError;
	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			if (memcmp((void *)0x0078CE49,(void *)Code,19) == 0)
			{
				Exe = 0;
				bhs = LoadLibrary("bhs.dll");
				LastError = GetLastError();
				if (!bhs)
				{
					FILE *f = fopen("dllload.txt","at");
					fprintf(f,"bhs.dll failed to load, error = %d",LastError);
					fclose(f);
					MessageBox(HWND_DESKTOP,"Error","bhs.dll not found",MB_OK|MB_ICONEXCLAMATION);
					exit(1);
				}
			}
			if (memcmp((void *)0x0078C6E9,(void *)Code,19) == 0)
			{
				Exe = 1;
				bhs = LoadLibrary("bhs.dll");
				LastError = GetLastError();
				if (!bhs)
				{
					FILE *f = fopen("dllload.txt","at");
					fprintf(f,"bhs.dll failed to load, error = %d",LastError);
					fclose(f);
					MessageBox(HWND_DESKTOP,"Error","bhs.dll not found",MB_OK|MB_ICONEXCLAMATION);
					exit(1);
				}
			}
			if (memcmp((void *)0x0078790C,(void *)Code,19) == 0)
			{
				Exe = 4;
			}
			InitEngine();
			wwscripts = LoadLibrary("scripts2.dll");
			LastError = GetLastError();
			if (wwscripts)
			{
				CreateScript = (cs) GetProcAddress(wwscripts,"Create_Script");
				DestroyScript = (ds) GetProcAddress(wwscripts,"Destroy_Script");
				GetScriptCount = (gsc) GetProcAddress(wwscripts,"Get_Script_Count");
				GetScriptName = (gsn) GetProcAddress(wwscripts,"Get_Script_Name");
				GetScriptParamDescription = (gspd) GetProcAddress(wwscripts,"Get_Script_Param_Description");
				SetScriptCommands = (ssc) GetProcAddress(wwscripts,"Set_Script_Commands");
				SetRequestDestroyFunc = (srdf) GetProcAddress(wwscripts,"Set_Request_Destroy_Func");
				OldCount = (GetScriptCount) ();
			}
			else
			{
				FILE *f = fopen("dllload.txt","at");
				fprintf(f,"scripts2.dll failed to load, error = %d",LastError);
				fclose(f);
				MessageBox(HWND_DESKTOP,"Error","Scripts2.dll not found",MB_OK|MB_ICONEXCLAMATION);
				exit(1);
			}
			break;
		case DLL_PROCESS_DETACH:
			FreeLibrary(wwscripts);
			break;
	}
	return TRUE;
}
#endif
ScriptClass SCRIPTSAPI *Create_Script(const char *ScriptName)
{
	if (ScriptName == NULL)
	{
		return 0;
	}
	ScriptClass *scr = ScriptRegistrar::CreateScript(ScriptName);
	if (scr != 0)
	{
		return scr;
	}
	return (CreateScript) (ScriptName);
}

void SCRIPTSAPI Destroy_Script(ScriptClass *scr)
{
	if (scr != 0)
	{
		delete scr;
	}
}

unsigned int SCRIPTSAPI Get_Script_Count()
{
	int sn = 0;
	sn = ScriptRegistrar::Count();
	return (GetScriptCount) () + sn;
}

char SCRIPTSAPI *Get_Script_Name(unsigned int Number)
{
	if (Number < OldCount)
	{
		return (GetScriptName) (Number);
	}
	int n = Number - OldCount;
	return ScriptRegistrar::GetScriptFactory(n)->GetName();
}

char SCRIPTSAPI *Get_Script_Param_Description(unsigned int Number)
{
	if (Number < OldCount)
	{
		return (GetScriptParamDescription) (Number);
	}
	int n = Number - OldCount;
	return ScriptRegistrar::GetScriptFactory(n)->GetParamDescription();
}
bool SCRIPTSAPI Set_Script_Commands(ScriptCommandsClass *ScriptCommands)
{
	Commands = *ScriptCommands;
	if ((Commands->version1 != 816) || (Commands->version2 != 174)) //if these dont match it means the ScriptCommands dont match with what is expected and the DLL cant work with whatever client is trying to use it
	{
		return false;
	}
	Commands->Enable_Stealth = (_Enable_Stealth)Address(bhs,"New_Enable_Stealth");
	Commands->Create_Explosion = (_Create_Explosion)Address(bhs,"New_Create_Explosion");
	Commands->Create_Explosion_At_Bone = (_Create_Explosion_At_Bone)Address(bhs,"New_Create_Explosion_At_Bone");
	Commands->Set_Fog_Enable = (_Set_Fog_Enable)Address(bhs,"New_Set_Fog_Enable");
	Commands->Set_Fog_Range = (_Set_Fog_Range)Address(bhs,"New_Set_Fog_Range");
	Commands->Set_War_Blitz = (_Set_War_Blitz)Address(bhs,"New_Set_War_Blitz");
	Commands->Fade_Background_Music = (_Fade_Background_Music)Address(bhs,"New_Fade_Background_Music");
	Commands->Set_Background_Music = (_Set_Background_Music)Address(bhs,"New_Set_Background_Music");
	Commands->Stop_Background_Music = (_Stop_Background_Music)Address(bhs,"New_Stop_Background_Music");
	Commands->Create_Sound = (_Create_Sound)Address(bhs,"New_Create_Sound");
	Commands->Create_2D_Sound = (_Create_2D_Sound)Address(bhs,"New_Create_2D_Sound");
	Commands->Create_2D_WAV_Sound = (_Create_2D_WAV_Sound)Address(bhs,"New_Create_2D_WAV_Sound");
	Commands->Create_3D_WAV_Sound_At_Bone = (_Create_3D_WAV_Sound_At_Bone)Address(bhs,"New_Create_3D_WAV_Sound_At_Bone");
	Commands->Create_3D_Sound_At_Bone = (_Create_3D_Sound_At_Bone)Address(bhs,"New_Create_3D_Sound_At_Bone");
	Commands->Play_Building_Announcement = (_Play_Building_Announcement)Address(bhs,"New_Play_Building_Announcement");
	Set_Background_Music_Player = (_Set_Background_Music_Player)Address(bhs,"New_Set_Background_Music_Player");
	Fade_Background_Music_Player = (_Fade_Background_Music_Player)Address(bhs,"New_Fade_Background_Music_Player");
	Stop_Background_Music_Player = (_Stop_Background_Music_Player)Address(bhs,"New_Stop_Background_Music_Player");
	Enable_Radar_Player = (_Enable_Radar_Player)Address(bhs,"New_Enable_Radar_Player");
	Display_GDI_Player_Terminal_Player = (_Display_GDI_Player_Terminal_Player)Address(bhs,"New_Display_GDI_Player_Terminal_Player");
	Display_NOD_Player_Terminal_Player = (_Display_NOD_Player_Terminal_Player)Address(bhs,"New_Display_NOD_Player_Terminal_Player");
	Set_Screen_Fade_Color_Player = (_Set_Screen_Fade_Color_Player)Address(bhs,"New_Set_Screen_Fade_Color_Player");
	Set_Screen_Fade_Opacity_Player = (_Set_Screen_Fade_Opacity_Player)Address(bhs,"New_Set_Screen_Fade_Opacity_Player");
	return (SetScriptCommands) (ScriptCommands);
}

void SCRIPTSAPI Set_Request_Destroy_Func(rdf Func)
{
	ScriptImpClass::Set_Request_Destroy_Func(Func);
	(SetRequestDestroyFunc) (Func);
}
#ifndef WIN32
/**
 * Scripts.so module patch.
 *
 * Written by Datalore.
 * Original idea by Mac.
 */

// Variable to keep track of patching
int scripts_patched = 0;
unsigned int relocation_offset = 0;
// Get the relocation address of our shared library
unsigned int get_relocate_offset(void)
{
	int result;
	__asm__(
		"call delta;"
		"delta:"
		"pop %%eax;"
		"sub $(delta),%%eax;"
		:"=a"(result)
		);
	return result;
}

// Functions to call back to the original binary
ScriptClass *ORG_Create_Script(const char *ScriptName)
{
	__asm__(
		".byte 0xc9;"						// leave
		".byte 0xe8; .byte 0x00; .byte 0x00; .byte 0x00; .byte 0x00;"	// call next instruction
		"org1:"
		"pop %ecx;"						// pop return address in ecx
		"sub $(org1),%ecx;"					// sub addresss of call from ecx
#ifdef RH8
		".byte 0x81; .byte 0xc1; .byte 0xbb; .byte 0x9e; .byte 0x36; .byte 0x08;"// add absolute target to ecx
#else
		".byte 0x81; .byte 0xc1; .byte 0x23; .byte 0x8d; .byte 0x3b; .byte 0x08;"	// add absolute target to ecx
#endif
		".byte 0x83; .byte 0xec; .byte 0x18;"			// original code
		".byte 0xff; .byte 0x74; .byte 0x24; .byte 0x1c;"	// original code
		".byte 0x67; .byte 0xff; .byte 0xe1;"			// jmp ecx
		);
	return 0; //silence compiler warning
}

void ORG_Destroy_Script(ScriptClass *scr)
{
	__asm__(
		".byte 0xc9;"
		".byte 0xe8; .byte 0x00; .byte 0x00; .byte 0x00; .byte 0x00;"
		"org2:"
		"pop %ecx;"
		"sub $(org2),%ecx;"
#ifdef RH8
		".byte 0x81; .byte 0xc1; .byte 0xcb; .byte 0x9e; .byte 0x36; .byte 0x08;"
#else
		".byte 0x81; .byte 0xc1; .byte 0x33; .byte 0x8d; .byte 0x3b; .byte 0x08;"
#endif
		".byte 0x83; .byte 0xec; .byte 0x0c;"
		".byte 0x8b; .byte 0x54; .byte 0x24; .byte 0x10;"
		".byte 0x67; .byte 0xff; .byte 0xe1;"
		);
}

unsigned int ORG_Get_Script_Count()
{
	return OldCount;
}

char *ORG_Get_Script_Name(unsigned int Number)
{
	__asm__(
		".byte 0xc9;"
		".byte 0xe8; .byte 0x00; .byte 0x00; .byte 0x00; .byte 0x00;"
		"org3:"
		"pop %ecx;"
		"sub $(org3),%ecx;"
#ifdef RH8
		".byte 0x81; .byte 0xc1; .byte 0x05; .byte 0x9f; .byte 0x36; .byte 0x08;"
#else
		".byte 0x81; .byte 0xc1; .byte 0x7b; .byte 0x8d; .byte 0x3b; .byte 0x08;"
#endif
		".byte 0x83; .byte 0xec; .byte 0x18;"
		".byte 0xff; .byte 0x74; .byte 0x24; .byte 0x1c;"
		".byte 0x67; .byte 0xff; .byte 0xe1;"
		);
	return 0; //silence compiler warning
}

char *ORG_Get_Script_Param_Description(unsigned int Number)
{
	__asm__(
		".byte 0xc9;"
		".byte 0xe8; .byte 0x00; .byte 0x00; .byte 0x00; .byte 0x00;"
		"org4:"
		"pop %ecx;"
		"sub $(org4),%ecx;"
#ifdef RH8
		".byte 0x81; .byte 0xc1; .byte 0x2f; .byte 0x9f; .byte 0x36; .byte 0x08;"
#else
		".byte 0x81; .byte 0xc1; .byte 0x8b; .byte 0x8d; .byte 0x3b; .byte 0x08;"
#endif
		".byte 0x83; .byte 0xec; .byte 0x18;"
		".byte 0xff; .byte 0x74; .byte 0x24; .byte 0x1c;"
		".byte 0x67; .byte 0xff; .byte 0xe1;"
		);
	return 0; //silence compiler warning
}

bool ORG_Set_Script_Commands(ScriptCommandsClass *ScriptCommands)
{
	__asm__(
		".byte 0xc9;"
		".byte 0xe8; .byte 0x00; .byte 0x00; .byte 0x00; .byte 0x00;"
		"org5:"
		"pop %ecx;"
		"sub $(org5),%ecx;"
#ifdef RH8
		".byte 0x81; .byte 0xc1; .byte 0x59; .byte 0x9f; .byte 0x36; .byte 0x08;"
#else
		".byte 0x81; .byte 0xc1; .byte 0xdb; .byte 0x8d; .byte 0x3b; .byte 0x08;"
#endif
		".byte 0x83; .byte 0xec; .byte 0x0c;"
		".byte 0x8b; .byte 0x44; .byte 0x24; .byte 0x10;"
		".byte 0x67; .byte 0xff; .byte 0xe1;"
		);
	return 0; //silence compiler warning
}

void ORG_Set_Request_Destroy_Func(rdf Func)
{
#ifdef RH8
	__asm__(
		".byte 0xc9;"
		".byte 0xe8; .byte 0x00; .byte 0x00; .byte 0x00; .byte 0x00;"
		"org6:"
		"pop %ecx;"
		"sub $(org6),%ecx;"
		".byte 0x81; .byte 0xc1; .byte 0xb9; .byte 0x9f; .byte 0x36; .byte 0x08;"
		".byte 0x83; .byte 0xec; .byte 0x0c;"
		".byte 0x8b; .byte 0x44; .byte 0x24; .byte 0x10;"
		".byte 0x67; .byte 0xff; .byte 0xe1;"
		);
#else
	__asm__(
		".byte 0xa3; .byte 0xa0; .byte 0x27; .byte 0x72; .byte 0x08;"
		:
		:"a"(Func)
		);
#endif
}

// Simple helper function to patch in a jmp
void patch_in_jmp(const unsigned int fixed_address, void* jmp_to)
{
	char* memory = (char*)fixed_address + relocation_offset;
	*memory = 0xe9;	// jmp instruction
	unsigned int* address = (unsigned int*)(fixed_address + relocation_offset + 1);
	*address = (unsigned int)jmp_to - fixed_address - relocation_offset - 5;	// relative address to jmp to
}

// The GLIBC function we hacked (ctime)
typedef void (*init) (int exetype);
char* CXIME(const time_t* tp)
{
	if(scripts_patched == 0)
	{
		scripts_patched = 1;
		char *error;
		init initbhs;
#ifdef RH8
		bhs = dlopen("./bhs8.so", RTLD_NOW);
		Exe = 3;
#else
		bhs = dlopen("./bhs.so", RTLD_NOW);
		Exe = 2;
#endif
		InitEngine();
		if (bhs)
		{
			initbhs = (init)dlsym(bhs, "initlinux");
#ifdef RH8
			initbhs(3);
#else
			initbhs(2);
#endif
		}
		else
		{
			printf("bhs.so not found.\n");
			exit(1);
		}
		printf("Linux Scripts Patch v0.01 enabled Renegade version.\n- Initializing scripts.so patch!\n");
		relocation_offset = get_relocate_offset();
		printf("- Scripts relocation offset: 0x%.8x\n", relocation_offset);
		// fill in function addresses
		CreateScript = (cs)((unsigned int)&ORG_Create_Script);
		DestroyScript = (ds)((unsigned int)&ORG_Destroy_Script);
		GetScriptCount = (gsc)((unsigned int)&ORG_Get_Script_Count);
		GetScriptName = (gsn)((unsigned int)&ORG_Get_Script_Name);
		GetScriptParamDescription = (gspd)((unsigned int)&ORG_Get_Script_Param_Description);
		SetScriptCommands = (ssc)((unsigned int)&ORG_Set_Script_Commands);
		SetRequestDestroyFunc = (srdf)((unsigned int)&ORG_Set_Request_Destroy_Func);
		// get the original script count
#ifdef RH8
		OldCount = ((gsc)(0x08369EF2 + relocation_offset))();
#else
		OldCount = ((gsc)(0x083B8D68 + relocation_offset))();
#endif
		printf("- Original built-in script count: %d\n", OldCount);
		// patch the function entries, so that they jmp to our script functions 
#ifdef RH8
		patch_in_jmp(0x08369EB4, (void*)&Create_Script);
		patch_in_jmp(0x08369EC4, (void*)&Destroy_Script);
		patch_in_jmp(0x08369EF2, (void*)&Get_Script_Count);
		patch_in_jmp(0x08369EFE, (void*)&Get_Script_Name);
		patch_in_jmp(0x08369F28, (void*)&Get_Script_Param_Description);
		patch_in_jmp(0x08369F52, (void*)&Set_Script_Commands);
		patch_in_jmp(0x08369FB2, (void*)&Set_Request_Destroy_Func);
#else
		patch_in_jmp(0x083B8D1C, (void*)&Create_Script);
		patch_in_jmp(0x083B8D2C, (void*)&Destroy_Script);
		patch_in_jmp(0x083B8D68, (void*)&Get_Script_Count);
		patch_in_jmp(0x083B8D74, (void*)&Get_Script_Name);
		patch_in_jmp(0x083B8DA4, (void*)&Get_Script_Param_Description);
		patch_in_jmp(0x083B8DD4, (void*)&Set_Script_Commands);
		patch_in_jmp(0x083B8E30, (void*)&Set_Request_Destroy_Func);
#endif
		// last output
		printf("- Total script count: %d\n", Get_Script_Count());
		printf("- Linux Scripts Patch succesfully\n");
	}
	return ctime(tp);
}
#endif
} //extern "C"
